/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.blue;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.DamageAction;
import com.megacrit.cardcrawl.actions.common.GainEnergyAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class Laser
extends AbstractCard {
    public static final String ID = "Laser";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Laser");
    public static final String NAME = "Laser";
    public static final String DESCRIPTION = "Deal !D! damage. NL Gain [B].";
    public static final String UPGRADED_DESCRIPTION = "Deal !D! damage. NL Gain [B] [B].";
    private static final int COST = 2;
    private static final int DAMAGE_AMT = 5;
    private static final int ENERGY_GAIN_AMT = 1;
    private static final int POOL = 1;

    public Laser() {
        super("Laser", "Laser", null, 2, DESCRIPTION, AbstractCard.CardType.ATTACK, AbstractCard.CardColor.BLUE, AbstractCard.CardRarity.COMMON, AbstractCard.CardTarget.ENEMY, 1);
        this.subType = AbstractCard.CardSubType.AMMO;
        this.baseDamage = 5;
        this.magicNumber = this.baseMagicNumber = 1;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)m, new DamageInfo(p, this.damage, this.damageTypeForTurn), AbstractGameAction.AttackEffect.FIRE));
        AbstractDungeon.actionManager.addToBottom(new GainEnergyAction(this.magicNumber));
    }

    @Override
    public void fire(AbstractPlayer p, AbstractMonster m) {
        this.use(p, m);
    }

    @Override
    public AbstractCard makeCopy() {
        return new Laser();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.upgradeMagicNumber(1);
            this.rawDescription = UPGRADED_DESCRIPTION;
            this.initializeDescription();
        }
    }
}

